/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.core.util.ResourceUtil;
import com.aptana.scripting.Messages;
import com.aptana.scripting.ScriptLogger;
import com.aptana.scripting.ScriptUtils;
import com.aptana.scripting.ScriptingActivator;
import com.aptana.scripting.model.RunType;
import com.aptana.scripting.model.ScriptLoadJob;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.ScriptingContainer;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptingEngine {
    private static final String FRAMEWORK_FILE_ID = "frameworkFiles";
    private static final String TAG_FILE = "file";
    private static final String ATTR_NAME = "name";
    private static final String LOADPATH_ID = "loadPaths";
    private static final String TAG_LOADPATH = "loadPath";
    private static final String ATTR_PATH = "path";
    private static ScriptingEngine instance;
    private ScriptingContainer _scriptingContainer;
    private List<String> _loadPaths;
    private List<String> _frameworkFiles;
    private RunType _runType = ScriptingActivator.getDefaultRunType();
    private boolean initialized;

    private ScriptingEngine() {
    }

    private ScriptingContainer createScriptingContainer(LocalContextScope scope) {
        ScriptingContainer result = new ScriptingContainer(scope, LocalVariableBehavior.TRANSIENT);
        try {
            File jrubyHome = null;
            Bundle jruby = Platform.getBundle((String)"org.jruby");
            URL url = FileLocator.find((Bundle)jruby, (IPath)new Path("lib"), null);
            if (url != null) {
                File lib = ResourceUtil.resourcePathToFile((URL)url);
                jrubyHome = lib.getParentFile();
            } else {
                jrubyHome = FileLocator.getBundleFile((Bundle)jruby);
            }
            result.setHomeDirectory(jrubyHome.getAbsolutePath());
            List loadPaths = result.getLoadPaths();
            loadPaths.addAll(0, this.getContributedLoadPaths());
            result.setLoadPaths(loadPaths);
        }
        catch (IOException e) {
            String message = MessageFormat.format(Messages.ScriptingEngine_Error_Setting_JRuby_Home, e.getMessage());
            IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (String)message, (Throwable)e);
            ScriptLogger.logError(message);
        }
        return result;
    }

    public synchronized List<String> getContributedLoadPaths() {
        if (this._loadPaths == null) {
            final ArrayList paths = new ArrayList();
            EclipseUtil.processConfigurationElements((String)"com.aptana.scripting", (String)LOADPATH_ID, (IConfigurationElementProcessor)new IConfigurationElementProcessor(){

                public void processElement(IConfigurationElement element) {
                    String path = element.getAttribute(ScriptingEngine.ATTR_PATH);
                    IExtension declaring = element.getDeclaringExtension();
                    String declaringPluginID = declaring.getNamespaceIdentifier();
                    Bundle bundle = Platform.getBundle((String)declaringPluginID);
                    URL url = bundle.getEntry(path);
                    String urlAsPath = ResourceUtil.resourcePathToString((URL)url);
                    if (urlAsPath != null && urlAsPath.length() > 0) {
                        paths.add(urlAsPath);
                    } else {
                        String message = MessageFormat.format(Messages.ScriptingEngine_Unable_To_Convert_Load_Path, declaringPluginID, url);
                        IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (String)message);
                    }
                }

                public Set<String> getSupportElementNames() {
                    return CollectionsUtil.newSet((Object[])new String[]{ScriptingEngine.TAG_LOADPATH});
                }
            });
            this._loadPaths = Collections.unmodifiableList(paths);
        }
        return this._loadPaths;
    }

    public synchronized List<String> getFrameworkFiles() {
        if (this._frameworkFiles == null) {
            final ArrayList names = new ArrayList();
            EclipseUtil.processConfigurationElements((String)"com.aptana.scripting", (String)FRAMEWORK_FILE_ID, (IConfigurationElementProcessor)new IConfigurationElementProcessor(){

                public void processElement(IConfigurationElement element) {
                    names.add(element.getAttribute(ScriptingEngine.ATTR_NAME));
                }

                public Set<String> getSupportElementNames() {
                    return CollectionsUtil.newSet((Object[])new String[]{ScriptingEngine.TAG_FILE});
                }
            });
            this._frameworkFiles = Collections.unmodifiableList(names);
        }
        return this._frameworkFiles;
    }

    public static synchronized ScriptingEngine getInstance() {
        if (instance == null) {
            instance = new ScriptingEngine();
        }
        return instance;
    }

    public synchronized ScriptingContainer getScriptingContainer() {
        if (this._scriptingContainer == null) {
            this._scriptingContainer = this.createScriptingContainer(LocalContextScope.SINGLETON);
        }
        return this._scriptingContainer;
    }

    public Object runScript(String fullPath, List<String> loadPaths) {
        return this.runScript(fullPath, loadPaths, this._runType, false);
    }

    public Object runScript(String fullPath, List<String> loadPaths, boolean async) {
        return this.runScript(fullPath, loadPaths, this._runType, async);
    }

    public Object runScript(String fullPath, List<String> loadPaths, RunType runType, boolean async) {
        ScriptLoadJob job = new ScriptLoadJob(fullPath, loadPaths);
        try {
            job.run("Load '" + fullPath + "'", runType, async);
        }
        catch (InterruptedException e) {
            String message = MessageFormat.format(Messages.ScriptingEngine_Error_Executing_Script, fullPath);
            ScriptUtils.logErrorWithStackTrace(message, e);
        }
        return async && this._runType != RunType.CURRENT_THREAD ? null : job.getReturnValue();
    }

    public synchronized ScriptingContainer getInitializedScriptingContainer() {
        ScriptingContainer sc = this.getScriptingContainer();
        if (!this.initialized) {
            sc.runScriptlet("require 'ruble'");
            this.initialized = true;
        }
        return sc;
    }
}

